import { jsx, jsxs } from "react/jsx-runtime";
import * as Popover from "@radix-ui/react-popover";
import { track, useContainer, useEditor, usePeerIds, useValue } from "@tldraw/editor";
import { useMenuIsOpen } from "../../hooks/useMenuIsOpen.mjs";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { PeopleMenuAvatar } from "./PeopleMenuAvatar.mjs";
import { PeopleMenuItem } from "./PeopleMenuItem.mjs";
import { PeopleMenuMore } from "./PeopleMenuMore.mjs";
import { UserPresenceEditor } from "./UserPresenceEditor.mjs";
const PeopleMenu = track(function PeopleMenu2({ children }) {
  const msg = useTranslation();
  const container = useContainer();
  const editor = useEditor();
  const userIds = usePeerIds();
  const userColor = useValue("user", () => editor.user.getColor(), [editor]);
  const userName = useValue("user", () => editor.user.getName(), [editor]);
  const [isOpen, onOpenChange] = useMenuIsOpen("people menu");
  return /* @__PURE__ */ jsxs(Popover.Root, { onOpenChange, open: isOpen, children: [
    /* @__PURE__ */ jsx(Popover.Trigger, { dir: "ltr", asChild: true, children: /* @__PURE__ */ jsxs("button", { className: "tlui-people-menu__avatars-button", title: msg("people-menu.title"), children: [
      userIds.length > 5 && /* @__PURE__ */ jsx(PeopleMenuMore, { count: userIds.length - 5 }),
      /* @__PURE__ */ jsxs("div", { className: "tlui-people-menu__avatars", children: [
        userIds.slice(-5).map((userId) => /* @__PURE__ */ jsx(PeopleMenuAvatar, { userId }, userId)),
        /* @__PURE__ */ jsx(
          "div",
          {
            className: "tlui-people-menu__avatar",
            style: {
              backgroundColor: userColor
            },
            children: userName === "New User" ? "" : userName[0] ?? ""
          }
        )
      ] })
    ] }) }),
    /* @__PURE__ */ jsx(Popover.Portal, { container, children: /* @__PURE__ */ jsx(
      Popover.Content,
      {
        dir: "ltr",
        className: "tlui-menu",
        align: "end",
        side: "bottom",
        sideOffset: 2,
        alignOffset: -5,
        children: /* @__PURE__ */ jsxs("div", { className: "tlui-people-menu__wrapper", children: [
          /* @__PURE__ */ jsx("div", { className: "tlui-people-menu__section", children: /* @__PURE__ */ jsx(UserPresenceEditor, {}) }),
          userIds.length > 0 && /* @__PURE__ */ jsx("div", { className: "tlui-people-menu__section", children: userIds.map((userId) => {
            return /* @__PURE__ */ jsx(PeopleMenuItem, { userId }, userId + "_presence");
          }) }),
          children
        ] })
      }
    ) })
  ] });
});
export {
  PeopleMenu
};
//# sourceMappingURL=PeopleMenu.mjs.map
